sub new {
  my $this = shift;
  my $self = $this->SUPER::new(@_);
  
  $self->globalobj->ppush('symbols', $self);
  
  return $self;	
}

sub nicename {
  my $self = shift;
  return '('.$self->get('varname').')'
    if (defined $self->get('library'));
  return $self->get('varname').'()'
    if ($self->get('isfunction'));
  return $self->get('varname');
}

sub useswhat {
  my $self = shift;

  my @using = $self->get('using');

  my $x = "\nFunctions/Variables used directly:\n==================================\n";

  return "$x(none)\n" unless (@using);

  my @where = $self->get('usingwhere');

  @where = grep { s/^.*:(.*)$/$1/e } @where; # Chop away file names

  my %usehash = ();
  my %wherehash = ();
  foreach my $f (@using) {
    my $where = shift @where;
    $self->set('recursive', 'directly')
      if ($f == $self);
    unless (defined $usehash{$f}) {
      $usehash{$f} = $f->nicename." at line(s): $where";
      $wherehash{$f.$where} = 1;
    } else {
      $usehash{$f} .= ", $where"
	unless (defined $wherehash{$f.$where});
    }
  }

  foreach my $f (@using) {
    next unless (defined $usehash{$f});
    $x .= $self->linebreak($usehash{$f}."\n", "  ");
    undef $usehash{$f};
  }
  return $x;
}

sub induseswhat {
  my $self = shift;

  my @uselist = $self->uselist;

  my $x = "\nFunctions/Variables used indirectly:\n====================================\n";

  my %donethat = ();
  my @clist = ();

  foreach my $f (@uselist) {
    my @nicenames = map { $_->nicename } @$f;

    while (@nicenames > 1) { # We run through each level of the chain.
      my $chain = join (" <- ", @nicenames);
      my $indenter = $nicenames[0]."  ";
      shift @nicenames;
      next if (defined $donethat{$chain});
      $donethat{$chain} = 1;

      $indenter =~ s/./ /g;
      push @clist,  $self->linebreak($chain."\n", $indenter);
    }
  }
  
  @clist = ("(none)\n")  unless (@clist);

  $x .= join("", sort @clist);

  return $x;
}

sub uselist {
  my $self = shift;

  my @uselist = $self->get('cache-uselist');
  return @uselist if (@uselist);

  $self->set('is_used', 1); # Mark this variable as used

  my @using = $self->get('using');
  return ( [] ) unless (@using);

  $self->set('mark', 1); # Prevent endless recursion 

  my %usehash = ();

  foreach my $f (@using) {
    next if (defined $usehash{$f});
    $usehash{$f} = 1;

    if ($f->get('mark')) {
      push @uselist, [ $f ];
      $f->set('recursive', 'indirectly') unless (defined $f->get('recursive'));
      next;
    }
    
    push @uselist, map { [@$_, $f] } $f->uselist;
  }    
  $self->set('mark', 0);

  $self->const('cache-uselist', @uselist);
  return @uselist;
}

sub usedbywhat {
  my $self = shift;

  my @using = $self->get('usedby');

  my $x = "\nFunctions/Variables using directly:\n===================================\n";
  return "$x(none)\n" unless (@using);

  my @where = $self->get('used');

  my %usehash = ();
  foreach my $f (@using) {
    my $where = shift @where;
    unless (defined $usehash{$f}) {
      $usehash{$f} = $f->nicename." at $where";
    } else {
      $usehash{$f} .= ", $where"
    }
  }

  foreach my $f (@using) {
    next unless (defined $usehash{$f});
    $x .= $self->linebreak($usehash{$f}."\n", "  ");
    undef $usehash{$f};
  }
  return $x;
}

sub indusedbywhat {
  my $self = shift;

  my @uselist = $self->usedbylist;

  my $x = "\nFunctions/Variables using indirectly:\n=====================================\n";

  my %donethat = ();
  my @clist = ();

  foreach my $f (@uselist) {
    my @nicenames = map { $_->nicename } @$f;

    while (@nicenames > 1) { # We run through each level of the chain.
      my $chain = join (" -> ", @nicenames);
      my $indenter = $nicenames[0]."  ";
      shift @nicenames;
      next if (defined $donethat{$chain});
      $donethat{$chain} = 1;

      $indenter =~ s/./ /g;
      push @clist,  $self->linebreak($chain."\n", $indenter);
    }
  }

  @clist = ("(none)\n")  unless (@clist);

  $x .= join("", sort @clist);

  return $x;
}

sub usedbylist {
  my $self = shift;

  my @uselist = $self->get('cache-usedbylist');
  return @uselist if (@uselist);

  my @using = $self->get('usedby');
  return ( [] ) unless (@using);

  $self->set('mark', 1); # Prevent endless recursion 

  my %usehash = ();

  foreach my $f (@using) {
    next if (defined $usehash{$f});
    $usehash{$f} = 1;

    if ($f->get('mark')) {
      push @uselist, [ $f ];
      next;
    }
    
    push @uselist, map { [@$_, $f] } $f->usedbylist;
  }    
  $self->set('mark', 0);

  $self->const('cache-usedbylist', @uselist);
  return @uselist;
}

sub report {
  my $self = shift;
  my $detailed = shift;

  my $x = "Variable's name: ".$self->nicename."\n";
  
  my $lib = $self->get('library');
  my $decl = $self->get('declared');

  if (defined $lib) {
    $x .= "Found in linkable library $lib\n";
  } else {
    if (defined $decl) {
      $x .= "Declared at $decl\n";
    } else {
      $x .= "*** Declaration missing ***\n";
    }
  }

  my $y = "";

  if (defined $decl) {
    $y .= $self->useswhat;
    $y .= $self->induseswhat if ($detailed);
  }

  $y .= $self->usedbywhat;
  $y .= $self->indusedbywhat if ($detailed);

  if (defined $decl) {
    if (defined $self->get('recursive')) {
      $x .= "Varible/function is recursive (".$self->get('recursive').")\n";
    } else {
      $x .= "Does not appear to be recursive in any way\n";
    }
  }

  return $x.$y;
}
