sub parse {
  my $self = shift;
  
  my $fname = shift;
  
  open FILE, "$fname" || puke("Failed to open $fname");
  
  my $line = "(error)";
  my @uses = ();
  my %locals = ();
  my %globals = ();
  my %functions = ();
  my %isfunction = ();
  my %used = ();
  my $nowfunction;
  my $nowlabel;

  my $srcname = "";
  my $srccnt = 0;

  my @fishy = ();

  my %objstaticfinder = ();
  my $objfinder = $self->globalobj->get('objfinder');
  unless (defined $objfinder) {
    $objfinder = {}; # Ref. to empty hash.
    $self->globalobj->const('objfinder', $objfinder);
  }

  # First loop to get the original file name.
  while (! (eof(FILE) )) {
    my $l = <FILE>;
    my ($n, $num) = ($l =~ /^[ \t]*\.stabs[ \t]*\"(.*?)\"[ \t]*,[ \t]*(\d+)/i);
    # NOTE: We hardcodedly assume that N_SO = 100
    next unless ((defined $n) && ($num == 100));
    $srcname .= $n;
    unless ($n =~ /\/$/) {	# Regexp matches final "/"
      $srccnt++;
      last;
    }
  }
	 
  blow("No file name attribute given in $fname (did you compile with -gstabs+ flag?)\n")
    unless ($srccnt>0);

  my @whenline = (); # Things to do when running into a line descriptor.
  
  # OK, now parsing the real stuff...
  while (! (eof(FILE) )) {
    my $l = <FILE>; chomp $l;

    next if ($l =~ /^[ \t]*\#/); # No lines beginning with "#"

    # We divide as assembly line to three kinds: Labels (name and ":"),
    # directives (starting with ".") and actual assembly commands.

    # *** LABELS *** They are strictest:

    my ($label, $afterjunk) = ($l =~ /^[ \t]*([\w\.]+)[ \t]*:[ \t]*(.*?)[ \t]*$/);
    $l = $afterjunk if (defined $afterjunk);
    if ((defined $label) && ($label =~ /^[A-Za-z_][A-Za-z_0-9\.]*$/)) {

      next if ($label =~ /^\./); # Don't bother with labels starting with "."
      
      $nowlabel = $label;

      $locals{$label} = $line
	unless (defined $globals{$label});
      next; # Finished with this label
    }

    # Now we verify that we didn't have something that looks like a label
    # but isn't:

    blow("Strange label definition in $fname line $.\n")
      if ($l =~ /^[ \t]*([^ \t]*):/);

    next unless (length($l) > 0);
    
    # *** DIRECTIVES *** They all begin with "."

    next if ($l =~ /^[ \t]*\.(\w+)[ \t]*$/); # Skip ".text" and such

    my ($directive, $data) = ($l =~ /^[ \t]*\.(\w+)[ \t]+(.*?)[ \t]*$/);
    if (defined $directive) {
      $directive = lc $directive; # We don't care about case
      my @d = map { (/^\s*(.*?)\s*$/) } (split ',',$data);

      if (($directive eq 'globl') || ($directive eq 'globl')) {
	# This is tricky, because the line number in the source is the
	# next to appear. So we create an anonymous function:
	
	my $globalname = $d[0];
	# We put a temporary value, so that the variable won't be marked
	# as local (actually, static).

	$globals{$globalname} = '***error***'; 

	push @whenline, sub { $globals{$globalname} = shift; };
	
	next;
      }

      # NOTE: We hardcodedly assume N_SLINE == 68 !
      if ($directive eq 'stabn') {
	if ($d[0] == 68) {
	  $line = $d[2];
	  
	  while (@whenline) {
	    &{shift @whenline}($line); # Call anonymous subroutines
	  }
	}
	next;
      }

      if ($directive eq 'stabs') {
	if ($data =~ /^[ \t]*\"(.*?)\"[ \t]*,[ \t]*130/) {
	  $line = "included from $1";
	}
	next;
      }

      
      if ($directive eq 'type') {
	if ($d[1] eq '@function') {
	  $nowfunction = $d[0];
	  
	  $functions{$nowfunction} = $line;
	}
	next;
      }

      if (grep { $directive eq $_ } qw[hword short word long int octa quad]) {
	$nowfunction = $nowlabel; # This can't be part of an executing function
	$l =~ s/^[ \t]*\.//; # Make this look like a mnemonic
      } else {
	next; # Unrecognized directive
      }
    }

    # *** ASSEMBLY MNEMONICS ***

    $l = $1 if ($l =~ /^[ \t]*\w+[ \t]*;(.*)$/); # Remove "rep;" and "lock;"
    next if ($l =~ /^[ \t]*(\w*)[ \t]*$/); # A non-operand mnemonic: skip
    
    my ($mnm, $ops) = ($l =~ /^[ \t]*(\w+)[ \t]+(.*?)$/);
    if (defined $mnm) {
      $ops =~ s/[ \t]//g; # Remove white spaces from data

    OP: foreach my $op (split ',', $ops) {
	$op = $1 if ($op =~ /^[\$\*]*(.*)/); # Remove "$" or "*" if present
	next OP unless ($op =~ /^([A-Za-z_][A-Za-z_0-9\.]*)/); # Legal variable name

	my $lbl = $1;

	push @uses, $lbl, $nowfunction, $line;
	$used{$lbl} = 1;
	# If the mnemonic was "call" we mark the symbol as a function
	# This is useful for library functions, which we never see
	# the definition of.

        $functions{$lbl} = '(undefined)' if ( ((lc $mnm) eq 'call') || ((lc $mnm) eq 'jmp') );
      }

      next; # Finished with mnemonic
    }
    push @fishy, "Warning: Didn't understand line $. of $fname: $l";
  }
  close FILE;

  # FINISHED PARSING.

  # First, a small sanity check: Are all local (static) variables used?

  foreach my $var (sort keys %locals) {
    push @fishy, "Fishy: Static variable $var defined in $srcname:$locals{$var} is never used"
      unless ($used{$var});
  }

  # Now we create an object for each global variable defined. Unless the
  # object already exists, of course.

  foreach my $var (sort keys %globals) {
    my $obj = $objfinder->{$var};

    unless (defined $obj) {
      my $plainname = $var; $plainname =~ s/[^a-zA-Z0-9_]/_/g;
      $obj = variable->new(name => $self->suggestname($plainname));
      $objfinder->{$var} = $obj;
    }

    $obj->ppush('declared', "$srcname:$globals{$var}");
    $obj->set('isfunction', ((defined $functions{$var}) ? 1 : 0));
    $obj->const('varname', $var);
  }

  # Now we create an object for each static variable defined. These
  # variables represent static variables. Naturally, they are not
  # listed in the 'objfinder' (name clashes would happen).

  foreach my $var (sort keys %locals) {
    my $plainname = $var; $plainname =~ s/[^a-zA-Z0-9_]/_/g;
    my $obj = variable->new(name => $self->suggestname("static_$plainname"));
    $objstaticfinder{$var} = $obj;

    $obj->ppush('declared', "$srcname:$locals{$var}");
    $obj->set('isfunction', ((defined $functions{$var}) ? 1 : 0));
    $obj->const('varname', $var);
    $obj->const('static', 1);
  }

  # Last thing: Go through each used global variable,
  # and make sure that the usage is noted in an object.
  
  while (@uses) {
    my ($var, $function, $srcline) = splice @uses, 0, 3;

    my $obj = $objstaticfinder{$var} ||  $objfinder->{$var};
    my $useobj = $objstaticfinder{$function} ||  $objfinder->{$function};

    # A small sanity check:
    blow("Weird error: ${function}() was declared as a function in $fname, but not as a symbol\n")
      unless (defined $useobj);

    unless (defined $obj) {
      my $plainname = $var; $plainname =~ s/[^a-zA-Z0-9_]/_/g;
      $obj = variable->new(name => $self->suggestname($plainname));
      $obj->set('isfunction', ((defined $functions{$var}) ? 1 : 0));
      $objfinder->{$var} = $obj;
    }
    
    $obj->ppush('used', "$srcname:$srcline");
    $obj->ppush('usedby', $useobj);
    $obj->const('varname', $var);

    $useobj->ppush('using', $obj);
    $useobj->ppush('usingwhere', "$srcname:$srcline");
  } 
  return @fishy if wantarray;
  return join "", map { "$_\n" } @fishy;
}
